% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPT-POT-extract.R
\name{extract_components}
\alias{extract_components}
\alias{extract_cpt}
\alias{extractCPT}
\alias{extractPOT}
\alias{extractMARG}
\alias{extract_pot}
\alias{extract_marg}
\alias{data2cpt}
\alias{data2pot}
\alias{data2marg}
\alias{marg2pot}
\alias{pot2marg}
\title{Extract conditional probabilities and clique potentials from
data.}
\usage{
extract_cpt(data_, graph, smooth = 0)

extract_pot(data_, graph, smooth = 0)

extract_marg(data_, graph, smooth = 0)

data2cpt(data_, graph, smooth = 0)

data2pot(data_, graph, smooth = 0)

data2marg(data_, graph, smooth = 0)

marg2pot(mg)

pot2marg(pt)
}
\arguments{
\item{data_}{A named array or a dataframe.}

\item{graph}{A \code{graphNEL} object or a list or formula which can be
turned into a \code{graphNEL} object by calling \code{ug} or
\code{dag}. For \code{extract_cpt}, graph must be/define a DAG while for
\code{extract_pot}, graph must be/define undirected triangulated graph.}

\item{smooth}{See 'details' below.}

\item{mg}{An object of class \code{marg_rep}}

\item{pt}{An object of class \code{pot_rep}}
}
\value{
\itemize{
\item \code{extract_cpt}: A list of conditional probability tables.
\item \code{extract_pot}: A list of clique potentials.
}
}
\description{
Extract list of conditional probability tables and
list of clique potentials from data.
}
\details{
If \code{smooth} is non-zero then \code{smooth} is added
to all cell counts before normalization takes place.

\code{extractCPT} is alias for \code{extract_cpt}
\code{extractPOT} is alias for \code{extract_pot} and
\code{extractMARG} is alias for \code{extract_marg}; retained
for backward compatibility.
}
\examples{

## FIXME: Review example 
## Asia (chest clinic) example:

## Version 1) Specify conditional probability tables.
yn <- c("yes","no")
a    <- cptable(~asia, values=c(1,99), levels=yn)
t.a  <- cptable(~tub+asia, values=c(5,95,1,99), levels=yn)
s    <- cptable(~smoke, values=c(5,5), levels=yn)
l.s  <- cptable(~lung+smoke, values=c(1,9,1,99), levels=yn)
b.s  <- cptable(~bronc+smoke, values=c(6,4,3,7), levels=yn)
e.lt <- cptable(~either+lung+tub,values=c(1,0,1,0,1,0,0,1), levels=yn)
x.e  <- cptable(~xray+either, values=c(98,2,5,95), levels=yn)
d.be <- cptable(~dysp+bronc+either, values=c(9,1,7,3,8,2,1,9), levels=yn)
plist <- compileCPT(list(a, t.a, s, l.s, b.s, e.lt, x.e, d.be))
pn1 <- grain(plist)
q1 <- querygrain(pn1)

## Version 2) Specify DAG and data
data(chestSim100000, package="gRbase")
dgf   <- ~asia + tub * asia + smoke + lung * smoke +
         bronc * smoke + either * tub * lung +
         xray * either + dysp * bronc * either
dg    <- dag(dgf)
pp    <- extract_cpt(chestSim100000, dg)

pn2   <- grain(pp)
## Same as:
cpp2  <- compileCPT(pp)
pn2   <- grain(cpp2)

q2    <- querygrain(pn2)

## Version 2) Specify triangulated undirected graph and data
ugf <- list(c("either", "lung", "tub"), c("either", "lung", "bronc"), 
    c("either", "xray"), c("either", "dysp", "bronc"), c("smoke", 
    "lung", "bronc"), c("asia", "tub"))
gg    <- ug(ugf)
pp    <- extract_pot(chestSim100000, gg)

pn3   <- grain(pp)
## Same as:
cpp3  <- compilePOT(pp)
pn3   <- grain(cpp3)

q3    <- querygrain(pn3)

## Compare results:
str(q1)
str(q2[names(q1)])
str(q3[names(q1)])

}
\references{
Søren Højsgaard (2012). Graphical Independence Networks
with the gRain Package for R. Journal of Statistical Software,
46(10), 1-26.  \url{http://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{compile_cpt}}, \code{\link{compile_pot}},
\code{\link{grain}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
