/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import org.af.commons.images.GraphDrawHelper;
import org.af.commons.images.GraphException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.gui.graph.Node;
import org.mutoss.gui.graph.VS;

public class Edge {
    private static final Log logger = LogFactory.getLog(Edge.class);
    public boolean curve = false;
    DecimalFormat format = new DecimalFormat("#.###");
    FontRenderContext frc = null;
    Graphics2D g2d;
    int k1;
    int k2;
    public Node nach;
    public Node von;
    VS vs;
    Double w;

    public Edge(Node von, Node nach, Double w, VS vs) {
        int x1 = von.getX() + Node.getRadius();
        int x2 = nach.getX() + Node.getRadius();
        int y1 = von.getY() + Node.getRadius();
        int y2 = nach.getY() + Node.getRadius();
        this.k1 = (x1 + x2) / 2;
        this.k2 = (y1 + y2) / 2;
        this.von = von;
        this.nach = nach;
        this.w = w;
        this.vs = vs;
    }

    public Edge(Node von, Node nach, Double w, VS vs, boolean curve) {
        this(von, nach, w, vs);
        int x1 = von.getX() + Node.getRadius();
        int x2 = nach.getX() + Node.getRadius();
        int y1 = von.getY() + Node.getRadius();
        int y2 = nach.getY() + Node.getRadius();
        if (curve) {
            double d = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
            double y = y2 - y1;
            double x = x2 - x1;
            double alpha = x == 0.0 && y < 0.0 ? 90.0 : (x == 0.0 && y > 0.0 ? -90.0 : Math.atan(-y / x) / (Math.PI * 2) * 360.0 + (double)(x < 0.0 ? 180 : 0));
            this.k1 = x1 + (int)(Math.cos((alpha += 10.0) * (Math.PI * 2) / 360.0) * d / 2.0);
            this.k2 = y1 - (int)(Math.sin(alpha * (Math.PI * 2) / 360.0) * d / 2.0);
        } else {
            this.k1 = (x1 + x2) / 2;
            this.k2 = (y1 + y2) / 2;
        }
    }

    public Edge(Node von, Node nach, Double w, VS vs, int k1, int k2) {
        this.von = von;
        this.nach = nach;
        this.w = w;
        this.vs = vs;
        this.k1 = k1;
        this.k2 = k2;
    }

    public int getBendLeft() {
        double[] m;
        int x1 = this.von.getX() + Node.getRadius();
        int x2 = this.nach.getX() + Node.getRadius();
        int y1 = this.von.getY() + Node.getRadius();
        int y2 = this.nach.getY() + Node.getRadius();
        try {
            m = GraphDrawHelper.getCenter((double)x1, (double)y1, (double)this.k1, (double)this.k2, (double)x2, (double)y2);
        }
        catch (GraphException e) {
            return 0;
        }
        double[] phi = GraphDrawHelper.getAngle((double)x1, (double)y1, (double)this.k1, (double)this.k2, (double)x2, (double)y2, (double)m[0], (double)m[1]);
        double gamma = x1 - x2 == 0 ? (double)(90 + (y2 - y1 > 0 ? 0 : 180)) : Math.atan((-y1 + y2) / (x1 - x2)) * 360.0 / (Math.PI * 2) + (double)(x1 - x2 < 0 ? 180 : 0);
        return ((int)(phi[2] + (double)(phi[1] > 0.0 ? 180 : 0) + 90.0 - gamma) + 360) % 360;
    }

    public int getK1() {
        return this.k1;
    }

    public int getK2() {
        return this.k2;
    }

    public double getPos() {
        double[] m;
        int x1 = this.von.getX() + Node.getRadius();
        int x2 = this.nach.getX() + Node.getRadius();
        int y1 = this.von.getY() + Node.getRadius();
        int y2 = this.nach.getY() + Node.getRadius();
        try {
            m = GraphDrawHelper.getCenter((double)x1, (double)y1, (double)this.k1, (double)this.k2, (double)x2, (double)y2);
            double d = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            double r = Math.sqrt((m[0] - (double)x1) * (m[0] - (double)x1) + (m[1] - (double)y1) * (m[1] - (double)y1));
            if (Math.PI * 2 * r / 360.0 > 6.0 * d / 200.0) {
                throw new GraphException("Edge is too linear.");
            }
        }
        catch (GraphException e) {
            double n2 = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            double k = Math.sqrt((this.k1 - x1) * (this.k1 - x1) + (this.k2 - y1) * (this.k2 - y1));
            if (k > n2) {
                return 1.0;
            }
            return k / n2;
        }
        double[] phi = GraphDrawHelper.getAngle((double)x1, (double)y1, (double)this.k1, (double)this.k2, (double)x2, (double)y2, (double)m[0], (double)m[1]);
        double phiA = phi[2];
        double phiC = phi[3];
        double phiK = phi[4];
        double d = phi[1];
        int n = phi[0] == phi[2] ? 1 : -1;
        if (d * (double)n > 0.0) {
            if (phiK < phiA) {
                phiK += 360.0;
            }
            if (phiC < phiK) {
                phiC += 360.0;
            }
            return (phiK - phiA) / (phiC - phiA);
        }
        if (phiK > phiA) {
            phiK -= 360.0;
        }
        if (phiC > phiK) {
            phiC -= 360.0;
        }
        return (phiK - phiA) / (phiC - phiA);
    }

    public Double getW() {
        return this.w;
    }

    private String getWS() {
        if (this.w.toString().equals("NaN")) {
            return "\u03b5";
        }
        return this.format.format(this.w);
    }

    public boolean inYou(int x, int y) {
        String s = this.getWS();
        FontRenderContext frc = this.g2d.getFontRenderContext();
        Rectangle2D rc = new Font("Arial", 0, (int)(16.0 * this.vs.getZoom())).getStringBounds(s, frc);
        int TOLERANCE = 4;
        return (double)x / this.vs.getZoom() > (double)this.k1 - rc.getWidth() / 2.0 - (double)TOLERANCE && (double)x / this.vs.getZoom() < (double)this.k1 + rc.getWidth() / 2.0 + (double)TOLERANCE && (double)y / this.vs.getZoom() < (double)this.k2 - rc.getHeight() * 1.0 / 2.0 + (double)TOLERANCE && (double)y / this.vs.getZoom() > (double)this.k2 - rc.getHeight() * 3.0 / 2.0 - (double)TOLERANCE;
    }

    public void paintYou(Graphics g) {
        int x1 = this.von.x + Node.getRadius();
        int x2 = this.nach.x + Node.getRadius();
        int y1 = this.von.y + Node.getRadius();
        int y2 = this.nach.y + Node.getRadius();
        if (this.von != this.nach) {
            int dx = x1 - this.k1;
            int dy = y1 - this.k2;
            double d = Math.sqrt(dx * dx + dy * dy);
            x1 -= (int)((double)(Node.getRadius() * dx) / d);
            y1 -= (int)((double)(Node.getRadius() * dy) / d);
            dx = this.k1 - x2;
            dy = this.k2 - y2;
            d = Math.sqrt(dx * dx + dy * dy);
            x2 += (int)((double)(Node.getRadius() * dx) / d);
            y2 += (int)((double)(Node.getRadius() * dy) / d);
            if (this.g2d == null) {
                this.g2d = (Graphics2D)g;
            }
            this.g2d = (Graphics2D)g;
            GraphDrawHelper.drawEdge((Graphics)g, (double)((int)((double)x1 * this.vs.getZoom())), (double)((int)((double)y1 * this.vs.getZoom())), (double)((int)((double)this.k1 * this.vs.getZoom())), (double)((int)((double)this.k2 * this.vs.getZoom())), (double)((int)((double)x2 * this.vs.getZoom())), (double)((int)((double)y2 * this.vs.getZoom())), (int)((int)(8.0 * this.vs.getZoom())), (int)35, (boolean)true);
            this.g2d.setFont(new Font("Arial", 0, (int)(16.0 * this.vs.getZoom())));
            this.frc = this.g2d.getFontRenderContext();
            String s = this.getWS();
            Rectangle2D rc = this.g2d.getFont().getStringBounds(s, this.frc);
            this.g2d.setColor(new Color(0.99f, 0.99f, 0.99f));
            this.g2d.fillRect((int)((double)this.k1 * this.vs.getZoom() - rc.getWidth() / 2.0), (int)((double)this.k2 * this.vs.getZoom() - rc.getHeight() * 3.0 / 2.0), (int)(rc.getWidth() + 5.0), (int)(rc.getHeight() + 5.0));
            this.g2d.setColor(Color.BLACK);
            this.g2d.drawString(s, (float)((double)this.k1 * this.vs.getZoom() - rc.getWidth() / 2.0), (float)((double)this.k2 * this.vs.getZoom() - rc.getHeight() / 2.0));
        } else {
            int r = Node.getRadius();
            g.drawArc((int)((double)(x1 - 109) * this.vs.getZoom()), (int)((double)(y1 - r / 2) * this.vs.getZoom()), (int)(100.0 * this.vs.getZoom()), (int)((double)r * this.vs.getZoom()), 45, 270);
            if (this.vs.directed) {
                // empty if block
            }
        }
    }

    public void setK1(int k1) {
        double correction = 0.0;
        this.k1 = k1 + (int)correction;
        if (this.k1 < 0) {
            this.k1 = 0;
        }
    }

    public void setK2(int k2) {
        double correction = 0.0;
        if (this.frc != null) {
            Rectangle2D rc = this.g2d.getFont().getStringBounds(this.getWS(), this.frc);
            correction = rc.getHeight() / 2.0;
        }
        this.k2 = k2 + (int)correction;
        if (this.k2 < 0) {
            this.k2 = 0;
        }
    }

    public void setW(Double w) {
        this.w = w;
        this.vs.nl.repaint();
    }
}

