% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.fuzzylm.R
\name{predict.fuzzylm}
\alias{predict.fuzzylm}
\title{Predict Method for Fuzzy Linear Regression}
\usage{
\method{predict}{fuzzylm}(object, newdata, ...)
}
\arguments{
\item{object}{a \code{fuzzylm} object.}

\item{newdata}{an optional data frame in which to look for variables with which to 
predict. If omitted, the fitted values are used.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\code{fuzzylm} object with \code{newdata} replacing the slot \code{x} and 
  predictions in triangular fuzzy number format representing the central values
  and left and right spreads replacing the slot \code{y}.
}
\description{
Predicts the central tendency and spreads from a fuzzy linear regression model.
}
\examples{
data(fuzzydat)
f <- fuzzylm(y ~ x, data = fuzzydat$lee)
predict(f)
}
\keyword{fuzzy}
