% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOF.R
\name{GOF}
\alias{GOF}
\title{Goodness of Fit of Fuzzy Regression Model}
\usage{
GOF(object, sc = 1e-06)
}
\arguments{
\item{object}{a \code{fuzzylm} object.}

\item{sc}{scaling constant used for numerical stability when spreads are equal to zero.}
}
\value{
A numeric.
}
\description{
Calculates mean error rate based on Diamond's distance of two variables representing
triangular fuzzy numbers, where one is the response variable and the other is the
prediction from a fuzzy regression model.
}
\details{
The Diamond's distance of two triangular fuzzy numbers is sum of squared differences
 of the core and both support values of the fuzzy numbers.
}
\examples{
data(bats)
f <- fuzzylm(temperature ~ MAST, data = bats)
GOF(f)
}
\references{
Diamond P. (1988) Fuzzy least squares. \emph{Information Sciences}
 46(3): 141-157.
   
 Wang N., Zhang W.-X., Mei C.-L. (2007) Fuzzy nonparametric regression
 based on local linear smoothing technique. \emph{Information Sciences}
 177: 3882-3900.
}
\seealso{
\code{\link{fuzzylm}}
}
