% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.fuzzylm.R
\name{coef.fuzzylm}
\alias{coef.fuzzylm}
\title{Extract Model Coefficients from Fuzzy Linear Model}
\usage{
\method{coef}{fuzzylm}(object, complete = TRUE, ...)
}
\arguments{
\item{object}{a \code{fuzzylm} object.}

\item{complete}{not used for a \code{fuzzylm} object.}

\item{...}{other arguments.}
}
\value{
matrix with coefficients for the central tendency of the model, upper and lower
  boundary.
}
\description{
Extracts coefficients of the fuzzy regression model in object \code{fuzzylm}.
}
\note{
The function returns real value numbers that define model predictions at 
  \eqn{\mu_{\tilde{y}}(x) = 1}{mu_y(x) = 1} and \eqn{\mu_{\tilde{y}}(x) > 0}{mu_y(x) > 0},
  not triangular fuzzy numbers. To extract triangular fuzzy number coefficients of the 
  model, use \code{object$coef}.
}
\examples{
  data(fuzzydat)
  f <- fuzzylm(y ~ x, data = fuzzydat$lee)
  coef(f)
}
