% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remote.R
\name{remote}
\alias{remote}
\title{Create a remote future whose value will be resolved asynchronously in a remote process}
\usage{
remote(expr, envir = parent.frame(), substitute = TRUE, lazy = FALSE,
  seed = NULL, globals = TRUE, persistent = TRUE, workers = NULL,
  user = NULL, revtunnel = TRUE, gc = FALSE, earlySignal = FALSE,
  myip = NULL, label = NULL, ...)
}
\arguments{
\item{expr}{An \R \link[base]{expression} to be evaluated.}

\item{envir}{The \link{environment} from where global
objects should be identified.  Depending on the future
strategy (the \code{evaluator}), it may also be the environment
in which the expression is evaluated.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{lazy}{Specifies whether a future should be resolved
lazily or eagerly (default).}

\item{seed}{(optional) A L'Ecuyer-CMRG RNG seed.}

\item{globals}{(optional) A logical, a character vector,
or a named list for controlling how globals are handled.
For details, see below section.}

\item{persistent}{If FALSE, the evaluation environment is cleared
from objects prior to the evaluation of the future.}

\item{workers}{The maximum number of multiprocess futures that
can be active at the same time before blocking.}

\item{user}{(optional) The user name to be used when communicating
with another host.}

\item{revtunnel}{If TRUE, reverse SSH tunneling is used for the
PSOCK cluster nodes to connect back to the master R process.  This
avoids the hassle of firewalls, port forwarding and having to know
the internal / public IP address of the master R session.}

\item{gc}{If TRUE, the garbage collector run (in the process that
evaluated the future) after the value of the future is collected.}

\item{earlySignal}{Specified whether conditions should be signaled
as soon as possible or not.}

\item{myip}{The external IP address of this machine.
If NULL, then it is inferred using an online service (default).}

\item{label}{An optional character string label attached to the future.}

\item{...}{Additional arguments passed to the "evaluator".}
}
\value{
A \link{ClusterFuture}.
}
\description{
A remote future is a future that uses remote cluster evaluation,
which means that its \emph{value is computed and resolved
remotely in another process}.
}
\details{
Note that remote futures use \code{persistent = TRUE} by default.
}
\examples{
\dontrun{\donttest{

## Use a remote machine
plan(remote, workers = "remote.server.org")

## Evaluate expression remotely
host \%<-\% { Sys.info()[["nodename"]] }
host
[1] "remote.server.org"

}}
}
