% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/multicore.R
\name{multicore}
\alias{multicore}
\title{Create a multicore future whose value will be resolved asynchroneously in a parallel process}
\usage{
multicore(expr, envir = parent.frame(), substitute = TRUE,
  globals = FALSE, maxCores = availableCores(), ...)
}
\arguments{
\item{expr}{An R \link[base]{expression}.}

\item{envir}{The \link{environment} in which the evaluation
is done and from which globals are obtained.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{globals}{If TRUE, global objects are validated at the point
in time when the future is created (always before it is resolved),
that is, they identified and located.  If some globals fail to be
located, an informative error is generated.}

\item{maxCores}{The maximum number of CPU cores that can
be active at the same time before blocking.}

\item{...}{Not used.}
}
\value{
A \link{MulticoreFuture} (or a \link{EagerFuture}
if multicore futures are not supported).
}
\description{
A multicore future is a future that uses multicore evaluation,
which means that its \emph{value is computed and resolved in
parallel in another process}.
}
\details{
This function will block if all CPU cores are occupied and
will be unblocked as soon as one of the already running
multicore futures is resolved.  For the total number of
CPU cores availble to the current R process, see
\code{\link{availableCores}()}.

Not all systems support multicore futures.  For instance,
it is not supported on Microsoft Windows.  Trying to create
multicore futures on non-supported systems will silently
fall back to using \link{eager} futures, which effectively
corresponds to a multicore future that can handle one parallel
process (the current one) before blocking.

The preferred way to create an multicore future is not to call
this function directly, but to register it via
\code{\link{plan}(multicore)} such that it becomes the default
mechanism for all futures.  After this \code{\link{future}()}
and \code{\link{\%<=\%}} will create \emph{multicore futures}.
}
\examples{
## A global variable
a <- 0

## Create multicore future (explicitly)
f <- multicore({
  b <- 3
  c <- 2
  a * b * c
})

## A multicore future is evaluated in a separated
## forked process.  Changing the value of a global
## variable will not affect the result of the future.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)
}
\seealso{
\code{\link{availableCores}() > 1L} to check whether multicore
futures are supported or not.
}

