% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchjobs_multicore.R
\name{batchjobs_multicore}
\alias{batchjobs_multicore}
\title{BatchJobs multicore futures}
\usage{
batchjobs_multicore(expr, envir = parent.frame(), substitute = TRUE,
  workers = availableCores(constraints = "multicore"), ...)
}
\arguments{
\item{expr}{An R expression to be evaluated.}

\item{envir}{The environment from which global environment
are search from.}

\item{substitute}{Controls whether \code{expr} should be
\code{substitute()}:d or not.}

\item{workers}{The number of multicore processes to be
available for concurrent BatchJobs multicore futures.}

\item{\ldots}{Additional arguments passed
to \code{\link{BatchJobsFuture}()}.}
}
\value{
An object of class \code{BatchJobsFuture}.
}
\description{
A BatchJobs multicore future is an asynchronous multiprocess
future that will be evaluated in a background R session.\cr
\cr
\emph{We highly recommend using \code{\link[future]{multisession}}
(sic!) futures of the \pkg{future} package instead of
multicore BatchJobs futures.}
}
\details{
BatchJobs multicore futures rely on the BatchJobs backend set
up by \code{\link[BatchJobs]{makeClusterFunctionsMulticore}()}.
The BatchJobs multicore backend only works on operating systems
supporting the `ps` command-line tool, e.g. Linux and OS X.
However, they are not supported on neither Windows nor Solaris
Unix (because `ps -o ucomm=` is not supported).  When not
supported, it falls back to \code{\link{batchjobs_local}}.

\emph{Warning: For multicore BatchJobs, the \pkg{BatchJobs}
package uses a built-in algorithm for load balancing based on
other processes running on the same machine.  This is done
in order to prevent the machine's CPU load to blow up.
Unfortunately, the BatchJobs criteria for handling this often
results in starvation, that is, long waiting times before
launching jobs.  The risk for this is particularly high if
there are other R processes running on the same machine
including those by other users.
See also \url{https://github.com/tudo-r/BatchJobs/issues/99}.
\bold{Conclusion:} We highly recommend using
\code{\link[future]{multisession}} futures of the
\pkg{future} package instead of multicore BatchJobs futures.}

Also, despite the name, BatchJobs multicore futures are in
function closer related to \link[future:multisession]{multisession}
futures than \link[future:multicore]{multicore} futures,
both provided by the \pkg{future} package.  This is because
BatchJobs spawns off background R sessions rather than forking
the current R process as the name otherwise might imply (at least
that is how the term "multicore processing" is typically used
in the R world).
}
\keyword{internal}

