% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_package_structure.R
\name{get_package_structure}
\alias{get_package_structure}
\alias{draw_package_structure}
\title{Get structure and information of a 'fusen' built package for developers}
\usage{
get_package_structure(config_file, emoji = TRUE, silent = FALSE)

draw_package_structure(structure_list, silent = FALSE)
}
\arguments{
\item{config_file}{Path to a source configuration file
to get the structure from}

\item{emoji}{Add emojis to the output}

\item{silent}{Whether to print messages}

\item{structure_list}{A list of information about the package as issued
from \verb{[get_package_structure()]}}
}
\value{
A list of information about the package
}
\description{
Get structure and information of a 'fusen' built package for developers

Draw a tree of the package structure in the console
}
\examples{
\dontrun{
# This only works inside a 'fusen' built package
pkg_structure <- get_package_structure()
draw_package_structure(pkg_structure)
}

# Example with a dummy package
dummypackage <- tempfile("drawpkg.structure")
dir.create(dummypackage)

# {fusen} steps
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
dev_file <- suppressMessages(
  add_flat_template(pkg = dummypackage, overwrite = TRUE, open = FALSE)
)
flat_file <- dev_file[grepl("flat_", dev_file)]

usethis::with_project(dummypackage, {
  # Add an extra R file with internal function
  # to list in "keep"
  dir.create("R")
  cat("extra_fun <- function() {1}\n", file = "R/my_extra_fun.R")

  # Works with classical package
  pkg_structure <- get_package_structure()
  draw_package_structure(pkg_structure)
})

usethis::with_project(dummypackage, {
  # Works with 'fusen' package
  suppressMessages(
    inflate(
      pkg = dummypackage,
      flat_file = flat_file,
      vignette_name = "Get started",
      check = FALSE,
      open_vignette = FALSE
    )
  )

  pkg_structure <- get_package_structure()
  draw_package_structure(pkg_structure)
})
}
