% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fclust.R
\name{sort_motifs}
\alias{sort_motifs}
\title{Sort assembly motifs}
\usage{
sort_motifs(fobs, assMotif, assNames,
            pvalue  = fpvalue(),
            opt.dec = TRUE   )
}
\arguments{
\item{fobs}{numeric vector.
The vector contains assemblage performances.}

\item{assMotif}{an integer vector of \code{length(fobs)}.
The vector contains the labels of each assemblages.
The labels are used to sorted the assemblages
that share a same assembly motif.}

\item{assNames}{a vector of strings of \code{length(fobs)}.
The vector contains the names of each assemblage.}

\item{pvalue}{a probability,
used as threshold
in the variance analysis. Then \code{pvalue} must be
higher than \code{0} and lower than \code{1}.
Groups significantly different
(at a p-value < \code{pvalue}) are then indicated by differents letters
on the right of boxplots.}

\item{opt.dec}{a logical.
If \code{opt.dec = TRUE},
assembly motifs are sorted by decreasing mean performances.
If \code{opt.dec = FALSE},
assembly motifs are sorted by increasing mean performances.}
}
\value{
Return a table
containing statistical properties of assembly motifs,
sorted by increasing or decreasing mean performances.
}
\description{
Sort assembly motifs,
 by decreasing or increasing mean performances
}
\details{
None.
}
\keyword{internal}
