% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fexport.R
\name{ftest_write}
\alias{ftest_write}
\title{Record the significance of different variables
 of a functional clustering}
\usage{
ftest_write(fres, rtest, filename,
            opt.var = c("components", "assemblages", "performances") )
}
\arguments{
\item{fres}{an object resulting from a functional clustering
obtained with the whole dataset using the function \code{\link{fclust}}.}

\item{rtest}{a list of matrices, each matrix containing
the results for a given clustering index.
The object \code{rtest} is generated by the function \code{ftest}.}

\item{filename}{a string, used as radical for naming the file
\code{"filename.components.csv"}, \code{"filemane.assemblages.csv"}
or \code{"filemane.performances.csv"}
according to the dimensions of matrices.}

\item{opt.var}{a string, specifying the last part of the file-name.
\code{opt} can only be equal to
\code{"components"}, \code{"assemblages"} or \code{"performances"}.}
}
\value{
Nothing. It is a procedure.
}
\description{
Record in a file the results of
a test of significance of functional clustering.
}
\details{
The functions \code{ftest},
  \code{ftest_components}, \code{ftest_assemblages} and
  \code{ftest_performances}
  generate a list containing a matrix by clustering index
  ("Czekanowski_Dice", "Folkes_Mallows", "Jaccard", "Kulczynski",
  "Precision", "Rand", "Recall", "Rogers_Tanimoto", "Russel_Rao",
  "Sokal_Sneath1" and "Sokal_Sneath2" index).
  Only their dimensions change according the used functions.
  Consequently, a same function is used for recording and reading
  the results of both the test-functions.
}
\examples{

# save "rtest" in the file "myRecord.*".

ftest_write(fres  = CedarCreek.2004.2006.res,
            rtest = CedarCreek.2004.2006.test.components,
            filename = tempfile(pattern = "myRecord", tmpdir = tempdir()),
            opt.var  = "components")

}
