% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fexport.R
\name{ftest}
\alias{ftest}
\title{Test the significance of different variables
 of a functional clustering}
\usage{
ftest(fres,
      opt.var = c("components", "assemblages", "performances"),
      opt.nbMax = fres$nbOpt, opt.R2 = FALSE, opt.plot = FALSE )
}
\arguments{
\item{fres}{an object resulting from a functional clustering
obtained with the whole dataset using the function \code{\link{fclust}}.}

\item{opt.var}{a string, that indicates the variable to test.
The option can be \code{"components"}, \code{"assemblages"}
or \code{"performances"}.}

\item{opt.nbMax}{a logical. If \code{opt.plot = TRUE},
at each test, the tree resulting from removing
 each component, assemblage or performance is plotted.}

\item{opt.R2}{a logical. If \code{opt.R2 = TRUE},
the primary tree is validated
and the vectors of coefficient of determination (\code{R^2})
and efficiency (\code{E}) are computed.}

\item{opt.plot}{a logical. If \code{opt.plot = TRUE},
at each test, the tree resulting from removing
each component, assemblage or performance is plotted.}
}
\value{
a list of matrices, each matrix containing
 the results for a given clustering index.
}
\description{
The function allows to test the relative significance of
 each component, of each assemblage and of each performance
 on the result of the functional clustering.
 The method is based on removing one after the other
 each component, assemblage or performance,
 then evaluating the effect of these deletions
 on the functional clustering. Each new functional clustering
 is compared with the functional clustering obtained
 with the whole dataset. The process is time-consuming.
}
\details{
None.
}
\examples{

# Enable the comments
oldOption <- getOption("verbose")
if (!oldOption) options(verbose = TRUE)
layout(matrix(c(1,2,3,4), nrow = 2, ncol = 2, byrow = TRUE))

\dontshow{
# Test the significance of annual biomass production
ftest(fres = CedarCreek.2004.2006.res,
      opt.var = c("performance"), opt.nbMax = 1)
}

\donttest{
# Test the significance of annual biomass production
test.perf <- ftest(fres = CedarCreek.2004.2006.res,
                   opt.var = c("performance"), opt.plot = TRUE)

# Test the significance of each component within each component cluster
test.comp <- ftest(fres = CedarCreek.2004.res,
                   opt.var = c("components"), opt.plot = TRUE)
}

layout(1)
options(verbose = oldOption)

}
