% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fclust.R
\name{format_fclust}
\alias{format_fclust}
\title{Format a raw dataset for a functional clustering}
\usage{
format_fclust(dat, nbElt, weight = rep(1, dim(dat)[2] - nbElt - 1),
              opt.na = FALSE, opt.repeat = FALSE, opt.mean   )
}
\arguments{
\item{dat}{a data.frame or matrix that brings together:
a vector of assemblage identity,
a matrix of occurrence of components within the system,
one or more vectors of observed performances.
Consequently, the data.frame or matrix dimensions are:
\code{dim(dat)[1]=} the number of observed assemblages,
\code{* dim(dat)[2]=} 1 + number of system components +
number of observed performances.
On a first line (colnames): assemblage identity,
a list of components identified by their names,
a list of performances identified by their names.
On following lines (a line by assemblage),
name of the assemblage (read as character),
a sequence of 0 (absence) and 1 (presence of component
within each assemblage)
(this is the matrix of occurrence of components within the system),
a sequence of numeric values for informed each observed performances
(this is the set of observed performances).}

\item{nbElt}{an integer, that specifies the number of components
belonging to interactive system.
\code{nbElt} is used to know the dimension of matrix of occurrence.}

\item{weight}{a vector of numerics,
that specifies the weight of each performance.
By default, each performance is equally weighted.
If \code{weight} is informed, it must have the same length
as the number of observed performances.}

\item{opt.na}{a logical.
The records for each assemblage can have \code{NA}
in matrix of occurrence or in observed assemblage performances.
If \code{opt.na = FALSE} (by default), an error is returned.
If \code{opt.na = TRUE}, the records with \code{NA} are ignored.}

\item{opt.repeat}{a logical.
in any case, the function looks for
different assemblages with identical elemental composition.
Messages indicate these identical assemblages.
If \code{opt.repeat = FALSE} (by default),
their performances are averaged.
If \code{opt.repeat = TRUE}, nothing is done,
and the data are processed as they are.}

\item{opt.mean}{a character, equals to \code{"amean"} or \code{"gmean"}.
If \code{opt.mean = "amean"},
means are computed using an arithmetic formula,
if \code{opt.mean = "gmean"},
mean are computed using a geometric formula.}
}
\value{
Return a list containing formatted inputs, that are:\cr

 \itemize{
 \item \code{fobs}: the vector of observed performances of assemblages.
 \code{names(fobs)} contains the names of assemblages.

 \item \code{mOccur}: the binary matrix of occurrence of components
 within the assemblages.
 \code{dim(mOccur) = [nbAss, nbElt]}.
 \code{rownames(mOccur)} contains the names of assemblages.
 \code{colnames(mOccur)} contains the names of components.

 \item \code{xpr}: the vector of weight of different experiments.
 \code{names(xpr)} contains the names of different experiments.
 }
}
\description{
Fit a raw dataset,
then format it as n input for the function \code{fclust}.
}
\details{
None.
}
\keyword{internal}
