% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{agglomerative_ftree}
\alias{agglomerative_ftree}
\title{Hierarchical agglomerative clustering of components}
\usage{
agglomerative_ftree(fobs, mOccur, xpr, opt.mean, opt.model)
}
\arguments{
\item{fobs}{a numeric vector. The vector \code{fobs} contains the
quantitative performances of assemblages.}

\item{mOccur}{a matrix of occurrence (occurrence of elements).
Its first dimension equals to \code{length(fobs)}. Its second dimension
 equals to the number of elements.}

\item{xpr}{a vector of numerics of \code{length(fobs)}.
The vector \code{xpr} contains the weight of each experiment,
and the labels (in \code{names(xpr)}) of different experiments.
The weigth of each experiment is used
in the computation of the Residual Sum of Squares
in the function \code{rss_clustering}.
The used formula is \code{rss}
if each experiment has the same weight.
The used formula is \code{wrss}
(barycenter of RSS for each experiment)
if each experiment has different weights.
All assemblages that belong to a given experiment
should then have a same weigth.
Each experiment is identified by its names (\code{names(xpr)})
and the RSS of each experiment is weighted by values of \code{xpr}.
The vector \code{xpr} is generated
by the function \code{stats::setNames}.}

\item{opt.mean}{a character equals to \code{"amean"} or \code{"gmean"}.
Switchs to arithmetic formula if \code{opt.mean = "amean"}.
Switchs to geometric formula if \code{opt.mean = "gmean"}. \cr

Modelled performances are computed
using arithmetic mean (\code{opt.mean = "amean"})
or geometric mean (\code{opt.mean = "gmean"})
according to \code{opt.model}.}

\item{opt.model}{a character equals to \code{"bymot"} or \code{"byelt"}.
Switchs to simple mean by assembly motif if \code{opt.model = "bymot"}.
Switchs to linear model with assembly motif if \code{opt.model = "byelt"}.
  \cr

If \code{opt.model = "bymot"},
modelled performances are means
of performances of assemblages
that share a same assembly motif
by including all assemblages that belong to a same assembly motif. \cr

If \code{opt.model = "byelt"},
modelled performances are the average
of mean performances of assemblages
that share a same assembly motif
and that contain the same components
as the assemblage to predict.
This procedure corresponds to a linear model within each assembly motif
based on the component occurrence in each assemblage.
If no assemblage contains component belonging to assemblage to predict,
performance is the mean performance of all assemblages
as in \code{opt.model = "bymot"}.}
}
\value{
Return an object "tree",
that is a list containing
\emph{(i)} \code{tree$aff}: an integer square-matrix of
component affectation to functional groups,
\emph{(ii)} \code{tree$cor}: a numeric vector of
coefficient of determination.
}
\description{
We proceed by grouping,
varying the number of functional groups of components
from the number of components until to 1.
All components are initially dispersed
into a singleton, as many singletons as components.
At each step, one of the functional groups is grouped
with another functional group: the new functional groups selected are
those that minimize the Residual Sum of Squares of the clustering.
The process stops when all components are grouped
into a large, unique functional group.
As a whole, the process generates a hierarchical aggloimerative tree
of component clustering, whose RSS decreases monotonically
with the number of functional groups.
}
\details{
At each hierarchical level of the agglomerative tree,
the clustering of the existing functional groups
into new functional groups proceeds as follows.
Each existing functional group is successively grouped
with other functional groups.
The component clustering that minimizes RSS is kept.
}
\keyword{internal}
