% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretize.R
\name{concatenate_n_vars}
\alias{concatenate_n_vars}
\title{Concatenate 'N' variables}
\usage{
concatenate_n_vars(data, vars)
}
\arguments{
\item{data}{data frame containing the two variables to concatenate}

\item{vars}{character vector containing all variables to concatenate}
}
\value{
vector containing the concatenated values for the given variables
}
\description{
Concatenate 'N' variables using the char pipe: <|>.
This function is used when there is the need of measuring the mutual information and/or the information
gain between 'N' input variables an against a target variable. This function makes sense when it is used based on
categorical data.
}
\examples{
\dontrun{
new_variable=concatenate_n_vars(mtcars, c("cyl", "disp"))
# Checking new variable
head(new_variable)
}
}
