% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploratory_data_analysis.R
\name{compare_df}
\alias{compare_df}
\title{Compare two data frames by keys}
\usage{
compare_df(dfcomp_x, dfcomp_y, keys_x, keys_y = NA, compare_values = FALSE)
}
\arguments{
\item{dfcomp_x}{first data frame to compare}

\item{dfcomp_y}{second data frame to compare}

\item{keys_x}{keys of the first dataframe}

\item{keys_y}{(optional) keys of the second dataframe, if missing both data frames will be compared with the keys_x}

\item{compare_values}{(optional) if TRUE it will not only compare keys, but also will check if the values of non-key matching columns have the same values}
}
\value{
Differences and coincident values
}
\description{
Obtain differences between two data frames
}
\examples{
data(heart_disease)
a=heart_disease
b=heart_disease
a=subset(a, age >45)
b=subset(b, age <50)
b$gender='male'
b$chest_pain=ifelse(b$chest_pain ==3, 4, b$chest_pain)
res=compare_df(a, b, c('age', 'gender'))
# Print the keys that didn't match
res
# Accessing the keys not present in the first data frame
res[[1]]$rows_not_in_X
# Accessing the keys not present in the second data frame
res[[1]]$rows_not_in_Y
# Accessing the keys which coincide completely
res[[1]]$coincident
# Accessing the rows whose values did not coincide
res[[1]]$different_values
}
