% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scopus_utils.R
\name{scopus_search}
\alias{scopus_search}
\title{Scopus search}
\usage{
scopus_search(query = NULL, count = 25, start = 0, type = "search",
  search_type = "scopus", key = NULL, ...)
}
\arguments{
\item{query}{(character) query terms, as a single character vector}

\item{count}{(integer/numeric) results to return: default: 25}

\item{start}{(integer/numeric) offset value, default: 0}

\item{type}{(character) type of search, default: search}

\item{search_type}{(character) search type, default: scopus}

\item{key}{(character) api key. get a key at
\url{https://dev.elsevier.com/index.html}}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Scopus search
}
\details{
Rate limits for search are 20,000 per every 7 days. You likely
won't make that many requests in 7 days, but if you do e.g., make 20K in
5 days, then you have to wait 2 days for the clock to reset, than you'll
be able to make 20K again.

See \url{https://dev.elsevier.com/api_key_settings.html} for rate
limit information.
}
\examples{
\dontrun{
res <- scopus_search(query = "ecology")
res

#scopus_search(query = x, type = "abstract")

# looping through
res <- scopus_search_loop(query = "ecology community elk cow")
}
}
\keyword{internal}
