gamma_matrix = function(idx, process){
  # A helper function used to build the Gamma Matrix
  N = ncol(process)
  temp_matrix <-  process[, c((idx+1):N)] %*% t(process[, c(1:(N - idx))])/N
  return(temp_matrix)
}

generate_critical_values = function(){
  vals = c(0.345165, 0.606783, 0.842567, 1.065349, 1.279713, 1.485200,
           1.690773, 1.897365, 2.096615, 2.288572, 2.496635, 2.686238,
           2.884214, 3.066906, 3.268958, 3.462039, 3.650724, 3.837678,
           4.024313, 4.214800, 4.404677, 4.591972, 4.778715, 4.965613,
           5.159057, 5.346543, 5.521107, 5.714145, 5.885108, 6.083306,
           
           0.460496, 0.748785, 1.001390, 1.239675, 1.469008, 1.684729,
           1.895557, 2.124153, 2.322674, 2.526781, 2.744438, 2.949004,
           3.147604, 3.336262, 3.544633, 3.740248, 3.949054, 4.136169,
           4.327286, 4.532917, 4.718904, 4.908332, 5.101896, 5.303462,
           5.495721, 5.688849, 5.866095, 6.068351, 6.242770, 6.444772,
           
           0.740138, 1.072101, 1.352099, 1.626695, 1.866702, 2.125950,
           2.342252, 2.589244, 2.809778, 3.033944, 3.268031, 3.491102,
           3.708033, 3.903995, 4.116829, 4.317087, 4.554650, 4.734714,
           4.974172, 5.156282, 5.369309, 5.576596, 5.759427, 5.973941,
           6.203718, 6.393582, 6.572949, 6.771058, 6.977607, 7.186491)
  critical_values = matrix(vals, nrow = 3, ncol = 30, byrow = TRUE)
  return(critical_values)
}
