% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoCorDiNUC_RNA.R
\name{AutoCorDiNUC_RNA}
\alias{AutoCorDiNUC_RNA}
\title{Di riboNucleotide Autocorrelation-Autocovariance (AutoCorDiNUC_RNA)}
\usage{
AutoCorDiNUC_RNA(
  seqs,
  selectedIdx = c("Rise (RNA)", "Roll (RNA)", "Shift (RNA)", "Slide (RNA)",
    "Tilt (RNA)", "Twist (RNA)"),
  maxlag = 3,
  threshold = 1,
  type = c("Moran", "Geary", "NormalizeMBorto", "AC", "CC", "ACC"),
  label = c()
)
}
\arguments{
\item{seqs}{is a FASTA file containing ribonucleic acid(RNA) sequences. The sequences start
with '>'. Also, seqs could be a string vector. Each element of the vector is a RNA sequence.}

\item{selectedIdx}{function takes as input the physicochemical properties. Users select the properties by their ids
or indices in the DI_RNA file. This parameter could be a vector or a list of di-ribonucleic acid indices.
The default value of this parameter is a vector with ("Rise (RNA)", "Roll (RNA)", "Shift (RNA)", "Slide (RNA)", "Tilt (RNA)","Twist (RNA)") ids.}

\item{maxlag}{This parameter shows the maximum gap between two amino acids. The gaps change from 1 to maxlag (the maximum lag).}

\item{threshold}{is a number between (0 to 1]. In selectedIdx, indices with a correlation higher than the threshold will be deleted.The default value is 1.}

\item{type}{could be 'Moran', 'Greay', 'NormalizeMBorto', 'AC', 'CC', or 'ACC'. Also, it could be any combination of them.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
This function returns a feature matrix. The number of columns in the matrix changes depending on the chosen autocorrelation or autocovariance types and nlag parameter.
The output is a matrix. The number of rows shows the number of sequences.
}
\description{
It creates the feature matrix for each function in autocorelation
(i.e., Moran, Greay, NormalizeMBorto) or autocovariance (i.e., AC, CC,ACC). The user can
select any combination of the functions too. In this case, the final matrix will contain
features of each selected function.
}
\details{
For CC and AAC autocovriance functions, which consider the covariance of the
two physicochemical properties, we have provided users with the ability to categorize
their selected properties in a list.
The binary combination of each group will be taken into account.
Note: If all the features are in a group or selectedAAidx parameter is a vector,
the binary combination will be calculated for all the physicochemical properties.
}
\examples{

fileLNC<-system.file("extdata/Carica_papaya101RNA.txt",package="ftrCOOL")
fileLNC<-fa.read(fileLNC,alphabet="rna")
fileLNC<-fileLNC[1:20]
mat1<-AutoCorDiNUC_RNA(seqs=fileLNC,maxlag=20,type=c("Moran","Geary"))

}
