% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{PWKT}
\alias{PWKT}
\alias{spa_pwkt}
\alias{format.pgeometry}
\alias{show,pgeometry-method}
\alias{as.character,pgeometry-method}
\title{Return PWKT representation of a spatial plateau object}
\usage{
spa_pwkt(pgo)

\method{format}{pgeometry}(x, ..., width = 30)

\S4method{show}{pgeometry}(object)

\S4method{as.character}{pgeometry}(x, ...)
}
\arguments{
\item{pgo}{A \code{pgeometry} object of any type.}

\item{x}{A \code{pgeometry} object of any type.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Unused.}

\item{width}{An integer value that indicates the number of characters to be printed. If it is 0 \code{NULL} or \code{NA}, then it will print everything.}

\item{object}{A \code{pgeometry} object of any type.}
}
\value{
A character object (i.e., string) with the textual representation of a given \code{pgeometry} object.
}
\description{
These functions give the Plateau Well-Known Text (PWKT) representation of a \code{pgeometry} object.
}
\details{
These functions return the textual representation of a \code{pgeometry} object,
which combines the Well-Known Text (WKT) representation for crisp vector geometry
objects and the formal definitions of spatial plateau data types.
(i.e. \code{PLATEAUPOINT}, \code{PLATEAULINE}, \code{PLATEAUREGION}, \code{PLATEAUCOMPOSITION}, and \code{PLATEAUCOLLECTION}).
}
\examples{
pcomp1 <- create_component("MULTIPOINT(1 2, 3 2)", 0.4)
pcomp2 <- create_component("POINT(2 1)", 0.3)
ppoint <- create_pgeometry(list(pcomp1, pcomp2), "PLATEAUPOINT")

# using spa_pwkt()
spa_pwkt(ppoint) 
# using show() to display the content of ppoint
ppoint
# using format with width = 30 (default value)
format(ppoint)

lcomp1 <- create_component("LINESTRING(1 2, 3 3, 3 4)", 1)
lcomp2 <- create_component("LINESTRING(0 0, 5 5)", 0.5)
pline <- create_pgeometry(list(lcomp1, lcomp2), "PLATEAULINE")

spa_pwkt(pline)

rcomp1 <- create_component("POLYGON((40 40, 20 48, 48 35, 40 40))", 0.8)
rcomp2 <- create_component("POLYGON((10 0, 40 18, 10 20, 5 18, 10 0))", 0.2)
pregion <- create_pgeometry(list(rcomp1, rcomp2), "PLATEAUREGION")

spa_pwkt(pregion)

pcomposition <- create_pgeometry(list(ppoint, pline, pregion), "PLATEAUCOMPOSITION")

spa_pwkt(pcomposition)

pcomp3 <- create_component("POINT(10 15)", 0.3)
ppoint2 <- create_pgeometry(list(pcomp3), "PLATEAUPOINT")

pcollection <- create_pgeometry(list(pcomposition, ppoint2), "PLATEAUCOLLECTION")

spa_pwkt(pcollection)
}
\references{
The formal definition of PWKT is given in:
\itemize{
\item \href{https://onlinelibrary.wiley.com/doi/10.1111/tgis.13044}{Carniel, A. C.; Venâncio, P. V. A. B; Schneider, M. fsr: An R package for fuzzy spatial data handling. Transactions in GIS, vol. 27, no. 3, pp. 900-927, 2023.}
}

Underlying concepts and formal definitions of spatial plateau data types are explained in detail in:
\itemize{
\item \href{https://ieeexplore.ieee.org/document/8491565}{Carniel, A. C.; Schneider, M. Spatial Plateau Algebra: An Executable Type System for Fuzzy Spatial Data Types. In Proceedings of the 2018 IEEE International Conference on Fuzzy Systems (FUZZ-IEEE 2018), pp. 1-8, 2018.}
\item \href{https://ieeexplore.ieee.org/document/9177620}{Carniel, A. C.; Schneider, M. Spatial Data Types for Heterogeneously Structured Fuzzy Spatial Collections and Compositions. In Proceedings of the 2020 IEEE International Conference on Fuzzy Systems (FUZZ-IEEE 2020), pp. 1-8, 2020.}
}
}
