% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsl_cluster.R
\name{fsl_cluster}
\alias{fsl_cluster}
\alias{fslcluster}
\alias{read_cluster_table}
\title{Form clusters, report information about clusters 
and/or perform cluster-based inference.  Wrapper for \code{cluster}}
\usage{
fsl_cluster(
  file,
  threshold,
  retimg = FALSE,
  reorient = FALSE,
  opts = "",
  cope_image = NULL,
  pthresh = NULL,
  peakdist = 0,
  volume = FALSE,
  smooth_est = NULL,
  voxel_resel = NULL,
  fractional = FALSE,
  connectivity = 26,
  mm = FALSE,
  find_minima = FALSE,
  standard_image = NULL,
  verbose = TRUE,
  ...
)

fslcluster(..., retimg = TRUE)

read_cluster_table(file)
}
\arguments{
\item{file}{filename of input volume}

\item{threshold}{threshold for input volume}

\item{retimg}{(logical) return image of class nifti}

\item{reorient}{(logical) If retimg, should file be reoriented when read in?
Passed to \code{\link{readnii}}.}

\item{opts}{(character) operations to be passed to \code{cluster}}

\item{cope_image}{filename of input cope volume}

\item{pthresh}{p-threshold}

\item{peakdist}{minimum distance between local maxima/minima, in mm (default 0)}

\item{volume}{number of voxels in the mask}

\item{smooth_est}{smoothness estimate = sqrt(det(Lambda))}

\item{voxel_resel}{Size of one resel in voxel units}

\item{fractional}{interprets the threshold as a fraction of the robust range}

\item{connectivity}{the connectivity of voxels (default 26)}

\item{mm}{use mm, not voxel, coordinates}

\item{find_minima}{find minima instead of maxima}

\item{standard_image}{filename for standard-space volume}

\item{verbose}{(logical) print out command before running}

\item{...}{additional arguments to pass to \code{\link{fslcmd}}}
}
\value{
A list of filenames of outputs and tables:
\itemize{
\item \code{opvals} filename for image output of log pvals
\item \code{oindex} filename for output of cluster index (in size order)
\item \code{othresh} filename for output of thresholded image
\item \code{olmax} filename for output of local maxima text file
\item \code{olmaxim} filename for output of local maxima volume
\item \code{osize} filename for output of size image
\item \code{omax} filename for output of max image
\item \code{omean} filename for output of mean image
}
}
\description{
Form clusters, report information about clusters 
and/or perform cluster-based inference.  Wrapper for \code{cluster}
}
\examples{
if (have_fsl()) { 
file = mni_fname(brain = TRUE, mask = FALSE)
threshold = 6000
clus = fsl_cluster(file, threshold)
}
}
