% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ortho_diff.R
\name{ortho_diff}
\alias{ortho_diff}
\title{Plot differences for Prediction and Gold Standard}
\usage{
ortho_diff(img, pred, roi, xyz = NULL, cols = c("#56B4E9", "#D55E00",
  "#009E73"), levels = c("False Negative", "False Positive", "True Positive"),
  addlegend = TRUE, center = TRUE, leg.cex = 1.5, ...)
}
\arguments{
\item{img}{image to be underlaid}

\item{pred}{binary segmentation (prediction)}

\item{roi}{binary manual segmentation (ground truth)}

\item{xyz}{coordinate for the center of the crosshairs.}

\item{cols}{colors for false negatives/positives}

\item{levels}{labels for false negatives/positives}

\item{addlegend}{add legend, passed to \code{\link{ortho2}}}

\item{center}{run \code{\link{xyz}} on \code{roi}.  Disregarded if \code{xyz} is
not \code{NULL}}

\item{leg.cex}{multiplier for legend size}

\item{...}{arguments to be passed to \code{\link{ortho2}}}
}
\description{
Uses \code{\link{ortho2}} to plot differences between a predicted binary
image and the assumed ground truth (\code{roi}).
}
\seealso{
\code{\link{ortho2}}
}

