% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{getIn}
\alias{getIn}
\title{Retrieve values from nested named lists}
\usage{
getIn(named_list, listkeys, default = NULL)
}
\arguments{
\item{named_list}{a named list}

\item{listkeys}{vector of character strings, the nested names of the lists}

\item{default}{the default value to return in case the requested value is `NULL`.}
}
\value{
the value at the path through the lists, or `NULL` (or the 'default') if no such path exists.
}
\description{
Retrieve values from nested named lists
}
\examples{
   data = list("regions"=list("frontal"=list("thickness"=2.3, "area"=2345)));
   getIn(data, c("regions", "frontal", "thickness"));       # 2.3
   getIn(data, c("regions", "frontal", "nosuchentry"));     # NULL
   getIn(data, c("regions", "nosuchregion", "thickness"));  # NULL
   getIn(data, c("regions", "nosuchregion", "thickness"), default=14);  # 14

}
