% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis.labeldata.on.subject}
\alias{vis.labeldata.on.subject}
\title{Visualize a label on the surface of a subject.}
\usage{
vis.labeldata.on.subject(
  subjects_dir,
  vis_subject_id,
  lh_labeldata,
  rh_labeldata,
  surface = "white",
  colormap = NULL,
  views = c("t4"),
  rgloptions = list(),
  rglactions = list(),
  draw_colorbar = FALSE,
  makecmap_options = list(colFn = label.colFn.inv)
)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{vis_subject_id}{string. The subject identifier from which to obtain the surface for data visualization. Example: 'fsaverage'.}

\item{lh_labeldata}{integer vector of vertex indices for the left hemisphere}

\item{rh_labeldata}{integer vector of vertex indices for the right hemisphere}

\item{surface}{string. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{colormap}{a colormap function. **DEPRECATED**: use parameter 'makecmap_options' instead, like this: \code{makecmap_options=list('colFn'=terrain.colors)}.}

\item{views}{list of strings. Valid entries include: 'si': single interactive view. 't4': tiled view showing the brain from 4 angles. 't9': tiled view showing the brain from 9 angles.}

\item{rgloptions}{option list passed to \code{\link[rgl]{par3d}}. Example: \code{rgloptions = list("windowRect"=c(50,50,1000,1000))}.}

\item{rglactions}{named list. A list in which the names are from a set of pre-defined actions. The values can be used to specify parameters for the action. The following example clips outliers in the data before plotting and writes a screenshot in PNG format: \code{rglactions = list("snapshot_png"="~/fsbrain.png", "clip_data"=c(0.05, 0.95))}.}

\item{draw_colorbar}{logical or one of the character strings 'vertical' or 'horizontal', whether to draw a colorbar. Notice: the colorbar is drawn to a separate subplot, and this only works if there is enough space for it, i.e., the plot resolution must be high enough. You may have to increase the plot size for the colorbar to show up, see the vignette for instructions. Defaults to `FALSE`. See  \code{\link[fsbrain]{coloredmesh.plot.colorbar.separate}} for an alternative.}

\item{makecmap_options}{named list of parameters to pass to \code{\link[squash]{makecmap}}. Must not include the unnamed first parameter, which is derived from 'measure'. Should include at least a colormap function as name 'colFn'.}
}
\value{
list of coloredmeshes. The coloredmeshes used for the visualization.
}
\description{
Visualizes a label. Note that a label is just a set of vertices, and that you can use this function to visualize sets of vertices, e.g., to see where on the mesh a certain vertex lies. It may be helpful the visualize the vertex with its neighbors, because otherwise it may be too small to spot. Use the function [fsbrain::mesh.vertex.neighbors] to get them. It is advisable to set the view to the interactive 'si' mode and use the 'inflated' surface to identify single vertices.
}
\note{
Drawing a colorbar for label data makes limited sense, use a legend instead. The colorbar can give a rough overview of the relative number of label and non-label vertices though, so it is possible to request one.
}
\examples{
\donttest{
   fsbrain::download_optional_data();

  # Define the data to use:
  subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
  lh_labeldata = c(1000, 1001, 1002);   # only the vertices, will be tiny.
  subject_id = 'subject1';
  surface = 'white'; # Should use 'inflated', but we do not currently
                     # ship it for the example subject to reduce download size.

  # For the right hemi, extend them to neighborhood for better visibility:
  rh_labeldata = c(500, 5000);
  rh_surface = subject.surface(subjects_dir, subject_id, surface, 'rh');
  rh_labeldata_neighborhood = mesh.vertex.neighbors(rh_surface, rh_labeldata);
  vis.labeldata.on.subject(subjects_dir, subject_id, lh_labeldata,
   rh_labeldata_neighborhood$vertices, surface=surface, views=c('si'));
}

}
\seealso{
Other label functions: 
\code{\link{apply.label.to.morphdata}()},
\code{\link{apply.labeldata.to.morphdata}()},
\code{\link{subject.lobes}()},
\code{\link{subject.mask}()},
\code{\link{vis.subject.label}()}

Other visualization functions: 
\code{\link{vis.color.on.subject}()},
\code{\link{vis.data.on.fsaverage}()},
\code{\link{vis.data.on.subject}()},
\code{\link{vis.mask.on.subject}()},
\code{\link{vis.region.values.on.subject}()},
\code{\link{vis.subject.annot}()},
\code{\link{vis.subject.label}()},
\code{\link{vis.subject.morph.native}()},
\code{\link{vis.subject.morph.standard}()},
\code{\link{vis.symmetric.data.on.subject}()},
\code{\link{vislayout.from.coloredmeshes}()}
}
\concept{label functions}
\concept{visualization functions}
