% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{annot.outline}
\alias{annot.outline}
\title{Compute outline vertex colors from annotation.}
\usage{
annot.outline(
  annotdata,
  surface_mesh,
  background = "white",
  silent = TRUE,
  expand_inwards = 0L
)
}
\arguments{
\item{annotdata}{an annotation, as returned by functions like \code{\link[fsbrain]{subject.annot}}.}

\item{surface_mesh}{brain surface mesh, as returned by functions like \code{\link[fsbrain]{subject.surface}} or \code{\link[freesurferformats]{read.fs.surface}}.}

\item{background}{color, the background color to assign to the non-border parts of the regions. Defaults to 'white'.}

\item{silent}{logical, whether to suppress status messages.}

\item{expand_inwards}{integer, additional thickness of the borders. Increases computation time, defaults to 0L.}
}
\value{
vector of colors, one color for each mesh vertex
}
\description{
For each region in an atlas, compute the outer border and color the respective vertices in the region-specific color from the annot's colortable.
}
