% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_bytes.R
\name{fs_bytes}
\alias{fs_bytes}
\alias{as_fs_bytes}
\title{Human readable file sizes}
\usage{
as_fs_bytes(x)

fs_bytes(x)
}
\arguments{
\item{x}{A numeric or character vector. Character representations can use
shorthand sizes (see examples).}
}
\description{
Construct, manipulate and display vectors of file sizes. These are numeric
vectors, so you can compare them numerically, but they can also be compared
to human readable values such as '10MB'.
}
\examples{
fs_bytes("1")
fs_bytes("1K")
fs_bytes("1Kb")
fs_bytes("1Kib")
fs_bytes("1MB")

fs_bytes("1KB") < "1MB"

sum(fs_bytes(c("1MB", "5MB", "500KB")))
}
