% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy.R
\name{copy}
\alias{copy}
\alias{file_copy}
\alias{dir_copy}
\alias{link_copy}
\title{Copy files, directories or links}
\usage{
file_copy(path, new_path, overwrite = FALSE)

dir_copy(path, new_path)

link_copy(path, new_path, overwrite = FALSE)
}
\arguments{
\item{path}{A character vector of one or more paths.}

\item{new_path}{A character vector of paths to the new locations.}

\item{overwrite}{Overwrite files if they exist. If this is \code{FALSE} and the
file exists an error will be thrown.}
}
\value{
The new path (invisibly).
}
\description{
\code{file_copy()} copies files.

\code{link_copy()} creates a new link pointing to the same location as the previous link.

\code{dir_copy()} copies the directory recursively at the new location.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
file_create("foo")
file_copy("foo", "bar")
try(file_copy("foo", "bar"))
file_copy("foo", "bar", overwrite = TRUE)
file_delete(c("foo", "bar"))

dir_create("foo")
# Create a directory and put a few files in it
files <- file_create(c("foo/bar", "foo/baz"))
file_exists(files)

# Copy the directory
dir_copy("foo", "foo2")
file_exists(path("foo2", path_file(files)))

# Create a link to the directory
link_create(path_abs("foo"), "loo")
link_path("loo")
link_copy("loo", "loo2")
link_path("loo2")

# Cleanup
dir_delete(c("foo", "foo2"))
link_delete(c("loo", "loo2"))
\dontshow{setwd(.old_wd)}
}
