% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.R
\name{file_chmod}
\alias{file_chmod}
\title{Change file permissions}
\usage{
file_chmod(path, mode)
}
\arguments{
\item{path}{A character vector of one or more paths.}

\item{mode}{A character representation of the mode, in either hexidecimal or symbolic format.}
}
\description{
Change file permissions
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
file_create("foo", "000")
file_chmod("foo", "777")
file_info("foo")$permissions

file_chmod("foo", "u-x")
file_info("foo")$permissions

file_chmod("foo", "a-wrx")
file_info("foo")$permissions

file_chmod("foo", "u+wr")
file_info("foo")$permissions

# It is also vectorized
files <- c("foo", file_create("bar", "000"))
file_chmod(files, "a+rwx")
file_info(files)$permissions

file_chmod(files, c("644", "600"))
file_info(files)$permissions
\dontshow{setwd(.old_wd)}
}
