% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.R
\name{is_file}
\alias{is_file}
\alias{is_dir}
\alias{is_link}
\title{Functions to test for file types}
\usage{
is_file(path)

is_dir(path)

is_link(path)
}
\arguments{
\item{path}{A character vector of one or more paths.}
}
\value{
A named logical vector, where the names give the paths. If the given
object does not exist, \code{NA} is returned.
}
\description{
Functions to test for file types
}
\examples{
\dontshow{fs:::pkgdown_tmp("/tmp/filedd46c01c6ad")}
tmp <- dir_create(file_temp())

file_create(path(tmp, "file.txt"))
dir_create(path(tmp, "dir"))
link_create(path(tmp, "file.txt"), path(tmp, "link"))

paths <- dir_ls(tmp)
is_file(paths)
is_dir(paths)
is_link(paths)
}
\seealso{
\code{\link[=file_exists]{file_exists()}}, \code{\link[=dir_exists]{dir_exists()}} and \code{\link[=link_exists]{link_exists()}} if you want
to ensure that the path also exists.
}
