% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_helpers.R
\name{get_run_r_tests}
\alias{get_run_r_tests}
\title{Get System Variable RUN_R_TESTS}
\usage{
get_run_r_tests(stop_on_failure = FALSE)
}
\arguments{
\item{stop_on_failure}{Throw an error instead of returning
\code{\link{FALSE}} if the environment variable is not set or cannot be
converted to boolean.}
}
\value{
The value RUN_R_TESTS is set to, converted to boolean.
\code{\link{FALSE}} if RUN_R_TESTS is not set or cannot be converted to
boolean.
}
\description{
A convenience wrapper to
\code{\link{get_boolean_envvar}("RUN_R_TESTS")}.
}
\examples{
set_run_r_tests("", force = TRUE) # make sure it is not set.
get_run_r_tests()
try(get_run_r_tests(stop_on_failure = TRUE))
set_run_r_tests("A", force = TRUE) # "A" is not boolean.
get_run_r_tests()
try(get_run_r_tests(stop_on_failure = TRUE))
set_run_r_tests(4213, force = TRUE) # All numbers apart from 0 are TRUE
get_run_r_tests()
set_run_r_tests("0", force = TRUE) # 0 (and "0") is FALSE
get_run_r_tests()
set_run_r_tests("FALSE", force = TRUE)
get_run_r_tests()
set_run_r_tests(TRUE, force = TRUE)
get_run_r_tests()
}
\seealso{
Other test helpers: 
\code{\link{get_boolean_envvar}()},
\code{\link{is_cran}()},
\code{\link{is_r_cmd_check}()},
\code{\link{is_running_on_fvafrcu_machines}()},
\code{\link{is_running_on_gitlab_com}()},
\code{\link{run_r_tests_for_known_hosts}()},
\code{\link{set_run_r_tests}()}

Other operating system functions: 
\code{\link{clipboard_path}()},
\code{\link{file_copy}()},
\code{\link{file_save}()},
\code{\link{get_boolean_envvar}()},
\code{\link{is_installed}()},
\code{\link{is_r_package_installed}()},
\code{\link{is_success}()},
\code{\link{is_windows}()},
\code{\link{view}()},
\code{\link{vim}()},
\code{\link{wipe_tempdir}()},
\code{\link{with_dir}()}

Other logical helpers: 
\code{\link{is_batch}()},
\code{\link{is_cran}()},
\code{\link{is_false}()},
\code{\link{is_force}()},
\code{\link{is_installed}()},
\code{\link{is_not_false}()},
\code{\link{is_null_or_true}()},
\code{\link{is_of_length_zero}()},
\code{\link{is_r_cmd_check}()},
\code{\link{is_r_package_installed}()},
\code{\link{is_running_on_fvafrcu_machines}()},
\code{\link{is_running_on_gitlab_com}()},
\code{\link{is_success}()},
\code{\link{is_version_sufficient}()},
\code{\link{is_windows}()}
}
\concept{logical helpers}
\concept{operating system functions}
\concept{test helpers}
