% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_assign.R
\name{line_assign}
\alias{line_assign}
\title{Wraps a line of code within a function in assign()}
\usage{
line_assign(.f, line, assign_to)
}
\arguments{
\item{.f}{A non-primitive function}

\item{line}{An expression from the body of the function}

\item{assign_to}{The name of the variable to assign to, as a string}
}
\value{
function
}
\description{
This function is used to assign expressions within a function to a value of your choice.
It can be used with line_insert() to modify what a function returns, add additional
conditional statements, and add more to already existing functions.
}
\examples{

new_map <- line_assign(strwidth, line = 3, assign_to = 'abc')
line_insert(new_map, after_line = 4, quote(return(abc)))


}
\seealso{
\code{\link{line_remove}} \code{\link{line_insert}}
}
