% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bootstrap.R
\name{bs_vars_state}
\alias{bs_vars_state}
\title{Bootstrap states variables}
\usage{
bs_vars_state(
  success_text = NULL,
  success_bg = NULL,
  success_border = NULL,
  info_text = NULL,
  info_bg = NULL,
  info_border = NULL,
  warning_text = NULL,
  warning_bg = NULL,
  warning_border = NULL,
  danger_text = NULL,
  danger_bg = NULL,
  danger_border = NULL
)
}
\arguments{
\item{success_text}{Success text color.}

\item{success_bg}{Success background color.}

\item{success_border}{Success border color.}

\item{info_text}{Info text color.}

\item{info_bg}{Info background color.}

\item{info_border}{Info border color.}

\item{warning_text}{Warning text color.}

\item{warning_bg}{Warning background color.}

\item{warning_border}{Warning border color.}

\item{danger_text}{Danger text color.}

\item{danger_bg}{Danger background color.}

\item{danger_border}{Danger border color.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Those variables can be used to customize
 states colors (used for alerts or panels) in Bootstrap and Bootswatch themes.
}
\note{
See default parameters for Bootstrap: \url{https://getbootstrap.com/docs/3.4/customize/}.
}
\examples{
# Panels & alerts colors
bs_vars_state(
  success_text = "#FFF",
  success_bg = "#238B45",
  success_border = "#00441B"
)

if (interactive()) {
  library(shiny)
  library(shinyWidgets)
  library(fresh)

  ui <- fluidPage(

    use_theme(create_theme(
      theme = "default",
      bs_vars_state(
        success_text = "#FFF",
        success_bg = "#238B45",
        success_border = "#00441B"
      )
    )),

    tags$h1("State variables"),
    fluidRow(
      column(
        width = 6,
        tags$div(
          class = "alert alert-success",
          tags$b("Alert!"), "this is an alert !"
        )
      ),
      column(
        width = 6,
        panel(
          status = "success",
          "This is a panel"
        )
      )
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
