% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/speclagreg.R
\name{speclagreg}
\alias{speclagreg}
\title{Estimate regresson operators in a lagged linear model}
\usage{
speclagreg(X, Y, Kconst = 1, K = NULL, lags = 0:0, freq = NULL,
  p = 10, q = 10, weights = "Bartlett")
}
\arguments{
\item{X}{first process}

\item{Y}{second process, if null then autocovariance of X is computed}

\item{Kconst}{used for heuristic as in \code{\link{reg.dim.est}}}

\item{K}{dimension for inversion if no heuristic should be used}

\item{lags}{which \eqn{A_k} should be estimated}

\item{freq}{grid of frequencies for computation as in \code{\link{fourier.transform}}}

\item{p}{window size for estimation of spectral density of X}

\item{q}{window size for estimation of spectral density of Y and X}

\item{weights}{as in \code{\link{spectral.density}}}
}
\value{
\code{timedom} operators
}
\description{
Estimate regresson operators in a lagged linear model using spectral methods.
Assume model
\deqn{Y_t = \sum_{k=-q}^p A_k X_{t-k} + \varepsilon_t}
where \eqn{X_t} is a stationary multivariate time series, \eqn{(A_k)_{-q \leq k \leq p}} is a filter and \eqn{\varepsilon_t} is white noise.
Function \code{speclagreg} estimates parameters \eqn{A_k} with \eqn{k \in }\code{lags}
}
\examples{
X = rar(100)
Y = rar(100)
#estimate regressors in model $Y_t = \\sum_{i\\in Z} A_i X_{t-i}$
A = speclagreg(X,Y)
# check an advanced examples in demo(lagged.reg)
}
\seealso{
\code{\link{linproc}}
}

