% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rbb.R
\name{rbb}
\alias{rbb}
\title{Generate brownian bridges}
\usage{
rbb(n = NULL, d = 100, BM = NULL)
}
\arguments{
\item{n}{number of observations to generate}

\item{d}{dimension (sampling at d points)}

\item{BM}{brownian motion to use}
}
\value{
n x d matrix with independent n observations
}
\description{
Generate independent Brownian bridges. If \code{BM} is specified
then bridges are constructed from a given Brownian Motion \code{BM}
\deqn{Y_t(u) = BM_t(u) - u BM_t(1)}
for each \eqn{t} and \eqn{u \in [0,1]}.
Otherwise \code{n} Brownian bridges are generated indipendently.
}
\examples{
bm = rbm(100)
plot(bm)
}
\seealso{
\code{\link{rbm}}
}

