% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fs_surface.R
\name{read.fs.surface}
\alias{read.fs.surface}
\title{Read file in FreeSurfer surface format}
\usage{
read.fs.surface(filepath, metadata = list())
}
\arguments{
\item{filepath}{string. Full path to the input curv file. Note: gzipped files are supported and gz format is assumed if the filepath ends with ".gz".}

\item{metadata}{named list of arbitrary metadata to store in the instance.}
}
\value{
named list. The list has the following named entries: "vertices": nx3 double matrix, where n is the number of vertices. Each row contains the x,y,z coordinates of a single vertex. "faces": nx3 integer matrix. Each row contains the vertex indices of the 3 vertices defining the face. WARNING: The indices are returned starting with index 1 (as used in GNU R). Keep in mind that you need to adjust the index (by substracting 1) to compare with data from other software. "vertex_indices_fs": list of n integers, where n is the number of vertices. The FreeSurfer vertex indices for the vertices.
}
\description{
Read a brain surface mesh consisting of vertex and face data from a file in FreeSurfer binary surface format. For a subject (MRI image pre-processed with FreeSurfer) named 'bert', an example file would be 'bert/surf/lh.white'.
}
\examples{
    surface_file = system.file("extdata", "lh.tinysurface",
                            package = "freesurferformats", mustWork = TRUE);
    mesh = read.fs.surface(surface_file);
    cat(sprintf("Read data for \%d vertices and \%d faces. \\n",
                            nrow(mesh$vertices), nrow(mesh$faces)));

}
\seealso{
Other mesh functions: \code{\link{write.fs.surface}}
}
\concept{mesh functions}
