\name{predict.frbs}
\alias{predict}
\alias{predict.frbs}
\title{The frbs prediction stage}
\usage{
  \method{predict}{frbs} (object, newdata, ...)
}
\arguments{
  \item{object}{an \code{\link{frbs-object}}.}

  \item{newdata}{a data frame or matrix (m x n) of data for
  the prediction process, where m is the number of
  instances and n is the number of input variables. It
  should be noted that the testing data must be expressed
  in numbers (numerical data).}

  \item{...}{the other parameters (not used)}
}
\value{
  The predicted values.
}
\description{
  This is the main function to obtain a final result as
  predicted values for all methods in this package. In
  order to get predicted values, this function is run using
  an \code{\link{frbs-object}}, which is typically
  generated using \code{\link{frbs.learn}}.
}
\examples{
##################################
## I. Regression Problem
###################################
## In this example, we just show how to predict using Wang and Mendel's technique but
## users can do it in the same way for other methods.
data.train <- matrix(c(5.2, -8.1, 4.8, 8.8, -16.1, 4.1, 10.6, -7.8, 5.5, 10.4, -29.0,
                       5.0, 1.8, -19.2, 3.4, 12.7, -18.9, 3.4, 15.6, -10.6, 4.9, 1.9,
                       -25.0, 3.7, 2.2, -3.1, 3.9, 4.8, -7.8, 4.5, 7.9, -13.9, 4.8,
                       5.2, -4.5, 4.9, 0.9, -11.6, 3.0, 11.8, -2.1, 4.6, 7.9, -2.0,
                       4.8, 11.5, -9.0, 5.5, 10.6, -11.2, 4.5, 11.1, -6.1, 4.7, 12.8,
                       -1.0, 6.6, 11.3, -3.6, 5.1, 1.0, -8.2, 3.9, 14.5, -0.5, 5.7,
                       11.9, -2.0, 5.1, 8.1, -1.6, 5.2, 15.5, -0.7, 4.9, 12.4, -0.8,
                       5.2, 11.1, -16.8, 5.1, 5.1, -5.1, 4.6, 4.8, -9.5, 3.9, 13.2,
                       -0.7, 6.0, 9.9, -3.3, 4.9, 12.5, -13.6, 4.1, 8.9, -10.0,
                       4.9, 10.8, -13.5, 5.1), ncol = 3, byrow = TRUE)

data.fit <- matrix(c(10.5, -0.9, 5.2, 5.8, -2.8, 5.6, 8.5, -0.2, 5.3, 13.8, -11.9,
                     3.7, 9.8, -1.2, 4.8, 11.0, -14.3, 4.4, 4.2, -17.0, 5.1, 6.9,
                     -3.3, 5.1, 13.2, -1.9, 4.6), ncol = 3, byrow = TRUE)

newdata <- matrix(c(10.5, -0.9, 5.8, -2.8, 8.5, -0.2, 13.8, -11.9, 9.8, -1.2, 11.0,
                      -14.3, 4.2, -17.0, 6.9, -3.3, 13.2, -1.9), ncol = 2, byrow = TRUE)

range.data<-matrix(c(0.9, 15.6, -29, -0.2, 3, 6.6), ncol=3, byrow = FALSE)
#############################################################
## I.1 Example: Implementation of Wang & Mendel
#############################################################
method.type <- "WM"

## collect control parameters into a list
## num.labels = 3 means we define 3 as the number of fuzzy terms
control.WM <- list(num.labels = 3, type.mf = "GAUSSIAN", type.tnorm = "MIN",
               type.snorm = "MAX", type.defuz = "WAM",
               type.implication.func = "ZADEH", name = "Sim-0")

## generate the model and save it as object.WM
\dontrun{object.WM <- frbs.learn(data.train, range.data, method.type, control.WM)}

## the prediction process
## The following code can be used for all methods
\dontrun{res <- predict(object.WM, newdata)}
}
\seealso{
  \code{\link{frbs.learn}} and \code{\link{frbs.gen}} for
  learning and model generation, and the internal main
  functions of each method for the theory:
  \code{\link{WM}}, \code{\link{SBC}}, \code{\link{HyFIS}},
  \code{\link{ANFIS}}, \code{\link{FIR.DM}},
  \code{\link{DENFIS}}, \code{\link{FS.HGD}},
  \code{\link{FRBCS.W}}, \code{\link{GFS.FR.MOGUL}},
  \code{\link{GFS.Thrift}}, \code{\link{GFS.GCCL}},
  \code{\link{FRBCS.CHI}}, \code{\link{FH.GBML}},
  \code{\link{GFS.LT.RS}} and \code{\link{SLAVE}}.
}

