% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.additivePenal.R
\name{summary.additivePenal}
\alias{summary.additivePenal}
\alias{print.summary.additivePenal}
\title{summary of parameter estimates of an additive frailty model}
\usage{
\method{summary}{additivePenal}(object, level = 0.95, len = 6, d = 2,
lab="hr", \dots)
}
\arguments{
\item{object}{output from a call to additivePenal.}

\item{level}{significance level of confidence interval. Default is 95\%.}

\item{len}{the total field width. Default is 6.}

\item{d}{the desired number of digits after the decimal point. Default of 6
digits is used.}

\item{lab}{label of printed results.}

\item{\dots}{other unused arguments.}
}
\value{
Prints HR and its confidence intervals for each covariate.
Confidence level is allowed (level argument)
}
\description{
This function returns hazard ratios (HR) and its confidence intervals
}
\examples{


\donttest{

data(dataAdditive)

modAdd <- additivePenal(Surv(t1,t2,event)~cluster(group)+var1+slope(var1),
correlation=TRUE,data=dataAdditive,n.knots=8,kappa=862,hazard="Splines")

#- 'var1' is boolean as a treatment variable.

summary(modAdd)

}


}
\seealso{
\code{\link{additivePenal}}
}
\keyword{methods}
