% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.jointSurroPenal.R
\name{predict.jointSurroPenal}
\alias{predict.jointSurroPenal}
\title{Predict Method for the one-step Joint surrogate model for the evaluation of a 
canditate surrogate endpoint.}
\usage{
\method{predict}{jointSurroPenal}(object, datapred = NULL, var.used = "error.estim", 
alpha. = 0.05, dec = 3, ...)
}
\arguments{
\item{object}{An object inheriting from \code{jointSurroPenal} class
(output from calling the function \code{jointSurroPenal}).}

\item{datapred}{Dataset to use for the prediction. If this argument is specified,
the data structure must be the same as the parameter \code{data} in the 
function \link{jointSurroPenal}. However, if observation on te true endpoint are
not available, columns timeT and \code{statusT} can be absent.}

\item{var.used}{This argument can take two values. The first one is \code{"error.estim"}
and indicates if the prediction error take into account
the estimation error of the estimates of the parameters. If the estimates 
are supposed to be known or if the dataset includes a high number of trials with 
a high number of subject per trial, value \code{No.error} can be used. 
The default is \code{error.estim}.}

\item{alpha.}{The confidence level for the prediction interval. The default is \code{0.05}}

\item{dec}{The desired number of digits after the decimal point for parameters
and confidence intervals. Default of 3 digits is used.}

\item{...}{other unused arguments.}
}
\value{
Return and display a dataframe including for each trial the number of included subjects, 
the observed 
treatment effect on the surrogate endpoint, the observed treatment effect on
the true endpoint (if available) and the predicted treatment effect on the 
true enpoint with the associated prediction intervals. If the observed treatment effect on the true 
endpoint (if available) is included into the prediction interval, the last columns contains "*".
}
\description{
{
Predict the treatment effect on the true endpoint (\eqn{beta_T}), based on the 
treatment effect observed on the surrogate endpoint (\eqn{beta_S}).
}
}
\details{
{
Prediction is based on the formulas described in (Burzikwosky \emph{et al.}, 2006).
We do not consider the case of prediction which suppose estimation error on 
the estimate of the treatment effect on the surrogate endpoint in the new trial.
}
}
\examples{


\dontrun{


###--- Joint surrogate model ---###
###---evaluation of surrogate endpoints---###

data(dataOvarian)
joint.surro.ovar <- jointSurroPenal(data = dataOvarian, n.knots = 8, 
                init.kappa = c(2000,1000), indicator.alpha = 0, 
                nb.mc = 200, scale = 1/365)

# prediction of the treatment effects on the true endpoint in each trial of 
the dataOvarian dataset
# predict(joint.surro.ovar)

}


}
\references{
Burzykowski T, Buyse M (2006). "Surrogate threshold effect: an alternative 
measure for meta-analytic surrogate endpoint validation." Pharmaceutical 
Statistics, 5(3), 173-186.ISSN 1539-1612.
}
\seealso{
\code{\link{jointSurroPenal}}
}
\author{
Casimir Ledoux Sofeu \email{casimir.sofeu@u-bordeaux.fr}, \email{scl.ledoux@gmail.com} and 
Virginie Rondeau \email{virginie.rondeau@inserm.fr}
}
\keyword{prediction}
\keyword{surrogate}
