% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_acronym.R
\name{species_acronym}
\alias{species_acronym}
\title{Acronym of a species in a specified database}
\usage{
species_acronym(species, database_id = NULL, database_inventory = NULL)
}
\arguments{
\item{species}{The scientific name of the plant species of interest}

\item{database_id}{ID number of an existing database on
\href{https://universalfqa.org/}{universalfqa.org}. Use
\code{\link[=index_fqa_databases]{index_fqa_databases()}} to see a list of
all such databases.}

\item{database_inventory}{An inventory of species having the same form as one
  created using \code{\link[=database_inventory]{database_inventory()}}, that
  is, a data frame with 9 columns:
  \itemize{
   \item scientific_name (character)
   \item family (character)
   \item acronym (character)
   \item nativity (character)
   \item c (numeric)
   \item w (numeric)
   \item physiognomy (character)
   \item duration (character)
   \item common_name (character)
}}
}
\value{
The acronym of the given species within the given database.
}
\description{
\code{species_acronym()} accepts a species and a database inventory and
returns the acronym of the species within that database. Either a numeric
database ID from \href{https://universalfqa.org/}{universalfqa.org} or a
homemade inventory with the same format may be specified.
}
\examples{
species_acronym("Anemone canadensis", database_id = 149)

}
