% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_kingdoms.R
\name{add_kingdoms}
\alias{add_kingdoms}
\title{add_kingdoms}
\usage{
add_kingdoms(x, phylum = "phylum", insert.left = TRUE)
}
\arguments{
\item{x}{A dataframe containing, minimally, phylum-level
assignments of the data}

\item{phylum}{A character of length 1 specifing the column
in x with the phylum level assignments}

\item{insert.left}{A convenience argument which will
make sure that the kingdom column will be inserted in
dataframe left immediately to the left of the phylum column}
}
\value{
The dataframe x, with the kingdom column inserted
}
\description{
Convenience function to add in a kingdom column to a PBDB
dataset. This relies on the dataset having a column of
phylum-level assignments for occurrences. The kingdom
column is a useful addition for filtering very large
taxonomically diverse datasets, and adds in an additional
level of data which can inform taxonomic cleaning routines
like those called by @seealso check_taxonomy
}
\examples{
# load dataset
data("brachios")
# add kingdoms to dataset
brachios <- add_kingdoms(brachios)
}
