% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pbdb.R
\name{get_pbdb}
\alias{get_pbdb}
\title{get_pbdb}
\usage{
get_pbdb(
  taxon = NULL,
  interval = NULL,
  mode = "occurrence",
  res = "all",
  fields = c("ident", "coords", "class"),
  ex_taxon = NULL,
  area = NULL,
  ex_area = NULL,
  invert_area = FALSE,
  litho = NULL,
  invert_litho = FALSE,
  env = NULL,
  ex_env = NULL,
  invert_env = NULL,
  pres = NULL,
  idqual = NULL,
  return_url = FALSE,
  return_data = TRUE,
  save_as = NULL,
  tscale = "ICS2013",
  wait = Inf
)
}
\arguments{
\item{taxon}{A character vector of taxon names. Prepending
a taxon name with ^ will exclude it from the PBDB search.
Alternatively @param ex_taxon can be used to do this}

\item{interval}{A numeric vector of length two with positive
ages in Ma, or a character vector containing one or two ICS
chronostratigraphic interval names}

\item{mode}{A character vector of length one specifying the
type of data to return: one of occurrence, collection, taxa,
specimen, measurement, strata, diversity, opinion or reference}

\item{res}{A character vector of length one specifying the
taxonomic resolution of the dataset: one of all, family, genus
species, lump_genus or lump_subgen. The latter two lump
multiple occurrences of genera or subgenera within collections
into a single representative occurrence}

\item{fields}{A character vector of PBDB vocabulary for
additional data fields to download:
see https://paleobiodb.org/data1.2/occs/list_doc.html}

\item{ex_taxon}{A character vector of taxon names to exclude
from the PBDB search}

\item{area}{If not NULL, then a numeric vector of length four
specifying, in order, the min lng, max lng, min lat and max
lat of the area from which occurrences will be returned, in
decimal degrees (equator = 0 lat, prime meridian = 0 lng).
Alternatively, a character vector of regions from which
occurrences will be returned: any valid country name or ISO2
code. Continent names and codes are also supported as follows:
ATA Antarctica, AFR Africa, ASI Asia, AUS Australia, EUR
Europe, IOC Indian Ocean, NOA North America, OCE Oceania,SOA
South America}

\item{ex_area}{If not NULL, then a character vector of
valid country names or ISO2 codes, as in @param area (), from
which occurrences will be excluded from a PBDB search}

\item{invert_area}{If TRUE, then regions specified in area
will be excluded from a PBDB search, except for the regions
specified in ex_area}

\item{litho}{If not NULL, a character vector of PBDB vocabulary
corresponding to which lithologies a PBDB search should return}

\item{invert_litho}{If TRUE, a character vector of PBDB
vocabulary corresponding to which lithologies a PBDB search
should exclude}

\item{env}{If not NULL, a character vector of PBDB vocabulary
corresponding to which environments a PBDB search should return}

\item{ex_env}{If not NULL, a character vector of PBDB vocabulary
corresponding to which environments a PBDB search should exclude}

\item{invert_env}{If TRUE, then environments specified in env
will be excluded from a PBDB search, except for the environments
specified in ex_env}

\item{pres}{A character vector of length one specifying the
preservation mode of the occurrences to return: one of regular,
form, ichno, or 'form,ichno'}

\item{idqual}{A character vector of length one specifying the
taxonomic certainty of the occurrences to return: one of certain,
genus_certain, uncertain, new"}

\item{return_url}{If TRUE, the function will return a correctly
formatted url suitable for use with curl or similar API functions,
comprising the search parameters set by the user}

\item{return_data}{If TRUE (default), the downloaded csv will
automatically be read into R (this must be assigned to an object)}

\item{save_as}{If not NULL, the file name to which the downloaded
data will be saved on the disk as a .csv}

\item{tscale}{A character vector of length one determining what
chronostratigraphic timescale will be applied to the data. "ICS2013"
will retain the PBDB ICS 2013 standard. "GTS2020" will update all
early and late interval ages to the GTS2020 standard, using a
lookup table supplied with the function. Alternatively, the
pathway to a custom .csv file  with columns Interval, FAD and
LAD where Interval are the names of the early and late intervals
in the PBDB, and FAD and LAD are the numeric lower and upper
boundaries of those intervals}

\item{wait}{The maximum wait time for the download in milliseconds,
as used by curl. This is set to no wait time by default}
}
\value{
either a PBDB API compatible URL or a PBDB dataset
}
\description{
Function for downloading Paleobiology Database (PBDB) data
(saved to disk and/or imported into R) or generating PBDB
API-compatible URLs. If downloading data over timespans
greater than 100 Ma, the download is performed in 100 Ma
chunks to better track the download progress.
}
\examples{
# download Triassic dinosaurs (wait time set to meet CRAN example requirement)
tdinos <- fossilbrush:::get_pbdb(taxon = "Dinosauria", interval = "Triassic", wait = 499)
}
