% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_extract_part.R
\name{str_extract_part}
\alias{str_extract_part}
\title{Extract strings before or after a given pattern}
\usage{
str_extract_part(string, pattern, before = TRUE)
}
\arguments{
\item{string}{A character vector.}

\item{pattern}{Pattern to look for.}

\item{before}{The position in the string to extract from. If TRUE, the extract will occur before the pattern; if FALSE, it will happen after the pattern.}
}
\value{
A subset of the input vector.
}
\description{
Vectorised over string and pattern.
}
\examples{

weekdays <- c(
  "Monday_1", "Tuesday_2", "Wednesday_3", "Thursday_4",
  "Friday_5", "Saturday_6", "Sunday_7"
)

str_extract_part(weekdays, before = TRUE, pattern = "_")

str_extract_part(c("$159", "$587", "$897"), before = FALSE, pattern = "$")

}
\seealso{
\code{\link[=str_split_extract]{str_split_extract()}} which splits up a string into pieces and extracts the results using a specified index position.
}
