% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{FORCE}
\alias{FORCE}
\title{FORCE panel kinship SNPs}
\format{
A data frame with 3915 rows and 6 columns:
\itemize{
\item \code{CHROM}: Chromosome (1-22)
\item \code{MARKER}: Marker name (rs number)
\item \code{MB}: Physical position in megabases (build GRCh38)
\item \code{A1}: First allele
\item \code{A2}: Second allele
\item \code{FREQ1}: Allele frequency of \code{A1}
}
}
\source{
Tillmar et al. The FORCE Panel: An All-in-One SNP Marker Set for
Confirming Investigative Genetic Genealogy Leads and for General Forensic
Applications. Genes. (2021)
}
\usage{
FORCE
}
\description{
A data frame describing (a subset of) the FORCE panel of SNPs designed for
applications in forensic genetics (Tillmar et al., 2021). The subset included
here are the SNPs recommended for kinship analysis. As the original
publication did not include allele frequencies, these were downloaded from
Ensembl via the biomaRt package. 15 markers were removed as frequency
information could not be retrieved.
}
\details{
To attach the FORCE markers to a pedigree, use \code{\link[pedtools:setSNPs]{pedtools::setSNPs()}} (see
Examples).
}
\examples{
x = setSNPs(nuclearPed(), snpData = FORCE)
summary(x)

getMap(x, markers = 1:5)
getFreqDatabase(x, markers = 1:5)

}
\keyword{datasets}
