% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markerSim.R
\name{simpleSim}
\alias{simpleSim}
\title{Unconditional marker simulation}
\usage{
simpleSim(
  x,
  N,
  alleles,
  afreq,
  ids,
  Xchrom = FALSE,
  mutmod = NULL,
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{a \code{ped} object}

\item{N}{a positive integer: the number of markers to be simulated}

\item{alleles}{a vector containing the allele names. If missing, the alleles
are taken to be \code{seq_along(afreq)}.}

\item{afreq}{a vector of length 2 containing the population frequencies for
the alleles. If missing, the alleles are assumed equifrequent.}

\item{ids}{a vector containing ID labels of those pedigree members whose
genotypes should be simulated.}

\item{Xchrom}{a logical: X linked markers or not?}

\item{mutmod}{a \code{\link[pedmut:mutationModel]{pedmut::mutationModel()}} object, i.e., list of mutation matrices named
'female' and 'male'.}

\item{seed}{NULL, or a numeric seed for the random number generator.}

\item{verbose}{a logical.}
}
\value{
a \code{ped} object equal to \code{x} in all respects except its \code{MARKERS}
entry, which consists of the \code{N} simulated markers.
}
\description{
Unconditional simulation of unlinked markers
}
\details{
This simulation is done by distributing alleles randomly to all founders,
followed by unconditional gene dropping down throughout the pedigree (i.e.
for each non-founder a random allele is selected from each of the parents).
Finally the genotypes of any individuals not included in \code{ids} are removed.
}
\examples{
library(pedtools)
x = nuclearPed(1)
simpleSim(x, N = 3, afreq = c(0.5, 0.5))

y = cousinPed(1, child = TRUE)
simpleSim(y, N = 3, alleles = LETTERS[1:10])

}
\seealso{
\code{\link[=markerSim]{markerSim()}}
}
\author{
Magnus Dehli Vigeland
}
