% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.formula.R
\name{reduce.existing.formula}
\alias{reduce.existing.formula}
\title{Reduce Existing Formula}
\usage{
reduce.existing.formula(the.initial.formula, dat,
  max.input.categories = 20, max.outcome.categories.to.search = 4,
  force.main.effects = TRUE, order.as = "as.specified",
  include.backtick = "as.needed", format.as = "formula")
}
\arguments{
\item{the.initial.formula}{object of class "lm" or for multiple responses of class c("mlm", "lm").}

\item{dat}{Data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model.}

\item{max.input.categories}{This limits the maximum number of variables that will be employeed in the formula. As default it is set at 20, but users can still change at his/her convinence.}

\item{max.outcome.categories.to.search}{This limits the maximum number of outcome categories will be investigated in the formula. As default it is set at 4, but users can still change at his/her convinence.}

\item{force.main.effects}{This is a logical value.  When TRUE, the intent is that any term included as an interaction (of multiple variables) must also be listed individually as a main effect.}

\item{order.as}{rearranges its first argument into ascending or descending order.}

\item{include.backtick}{Add backticks to make a appropriate variable}

\item{format.as}{The data type of the output.  If not set as "formula", then a character vector will be returned.}
}
\description{
Reduce Existing Formula
}
\examples{
the.initial.formula <- Awareness ~ .

reduce.existing.formula(the.initial.formula = the.initial.formula,dat = snack.dat,
  max.input.categories = 30)$formula

}
