% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formods.R
\name{FM_init_state}
\alias{FM_init_state}
\title{Initialize a formods State Object}
\usage{
FM_init_state(
  FM_yaml_file,
  MOD_yaml_file,
  id,
  dep_mod_ids = c(),
  MT,
  button_counters,
  ui_ids,
  ui_hold,
  session
)
}
\arguments{
\item{FM_yaml_file}{App configuration file with FM as main section.}

\item{MOD_yaml_file}{Module configuration file with MC as main section.}

\item{id}{Shiny module ID.}

\item{dep_mod_ids}{Vector of module ids this module depends on.}

\item{MT}{Type of module using the short name (e.g. "UD", "FG", etc.).}

\item{button_counters}{Vector of button UI elements that need to be tracked.}

\item{ui_ids}{List of UI ids in the module.}

\item{ui_hold}{Vector of UI elements that require holding.}

\item{session}{Shiny session variable}
}
\value{
List with state initialized.
}
\description{
Initializes a formods state object with common elements.
}
\examples{
# Within shiny a session variable will exist,
# this creates examples here for testing purposes:
sess_res = UD_test_mksession(session=list())
session = sess_res$session
state = FM_init_state(
   FM_yaml_file  = system.file(package = "formods",
                               "templates",
                               "formods.yaml"),
   MOD_yaml_file = system.file(package = "formods",
                               "templates",
                               "UD.yaml"),
   id              = "UD",
   MT              = "UD",
   button_counters = NULL,
   ui_ids          = NULL,
   ui_hold         = NULL,
   session         = session)

state
}
