% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{atmos}
\alias{atmos}
\title{Properties of standard atmosphere}
\format{
Classes data.table and data.frame: 9 observations of 5 variables:
\describe{
\item{alt}{Numeric, altitude (m)}
\item{temp}{Numeric, air temperature (K)}
\item{pres}{Numeric, atmospheric pressure (Pa)}
\item{dens}{Numeric, air density (kg m\eqn{^{-3}}{^{-13}})}
\item{sound}{Numeric, speed of sound (m/s)}
}
}
\source{
\emph{Marks' Standard Handbook for Mechanical Engineers 9/e} (1987)
E.A. Avallone and T. Baumeister (ed.),
"Table 4.2.2 International Standard Atmosphere",
pp. 4-38,  McGraw-Hill, NY.
}
\usage{
data(atmos, package = "formatdown")
}
\description{
Table of atmospheric properties as a function of altitude, sea level to
80 km.
}
\keyword{datasets}
