% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_power.R
\name{format_power}
\alias{format_power}
\title{Format powers of ten}
\usage{
format_power(x, digits = 3, ..., format = "engr", omit_power = c(-1, 2))
}
\arguments{
\item{x}{Numeric vector to be formatted.}

\item{digits}{Numeric scalar, nonzero positive integer to specify the
number of significant digits in the output coefficient.}

\item{...}{Not used, force later arguments to be used by name.}

\item{format}{Character. Possible values are "engr" (engineering notation)
and "sci" (scientific notation). Use argument  by name.}

\item{omit_power}{Numeric vector \code{c(p, q)} specifying the range of
exponents over which power of ten notation is omitted, where
\code{p <= q}. If NULL all numbers are formatted in powers of ten
notation. Use argument by name.}
}
\value{
A character vector with the following properties:
\itemize{
    \item Numbers represented in powers of ten notation except for those
          with exponents in the range specified in \code{omit_power}
    \item Elements delimited with \code{$...$} for rendering as
          inline math in an R Markdown or Quarto Markdown document.
}
}
\description{
Convert the elements of a numerical vector to character strings in which
the numbers are formatted using powers-of-ten notation in scientific or
engineering form and delimited for rendering as inline equations in an
R Markdown document.
}
\details{
Given a number, a numerical vector, or a numerical column from a data frame,
\code{format_power()} converts the numbers to character strings of the form,
\code{"$a\\\\times{10}^{n}$"}, where \code{a} is the coefficient and \code{n}
is the exponent. The string includes markup delimiters \code{$...$} for
rendering as an inline equation in R Markdown or Quarto Markdown
document. The user can specify the number of significant digits and scientific
or engineering format.

Powers-of-ten notation is omitted over a range of exponents via
\code{omit_power} such that numbers are converted to character strings of
the form, \code{"$a$"}, where \code{a} is the number in decimal notation.
The default \code{omit_power = c(-1, 2)} formats numbers such as 0.123, 1.23,
12.3, and 123 in decimal form. To cancel these exceptions and convert all
numbers to powers-of-ten notation, set the \code{omit_power} argument to
NULL.
}
\examples{
# Scalar value
format_power(101100)

# Vector value
x <- c(1.2222e-6, 2.3333e-5, 3.4444e-4, 4.1111e-3, 5.2222e-2, 6.3333e-1,
       7.4444e+0, 8.1111e+1, 9.2222e+2, 1.3333e+3, 2.4444e+4, 3.1111e+5, 4.2222e+6)
format_power(x)

# Compare significant digits
format_power(x[1], 3)
format_power(x[1], 4)

# Compare format type
format_power(x[3], format = "engr")
format_power(x[3], format = "sci")

# Compare omit_power range
format_power(x[6], omit_power = c(-1, 2))
format_power(x[6], omit_power = c(0, 2))
format_power(x[8])
format_power(x[8], omit_power = NULL)

# Apply to columns of a data frame (data.table syntax)
y <- x[1:6]
z <- x[8:13]
DT <- data.table::data.table(y, z)
DT[, lapply(.SD, function(x) format_power(x))]
}
\concept{format_*}
