% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/forestplot_helpers.R
\name{prFpDrawLine}
\alias{prFpDrawLine}
\title{Draws a straight line}
\usage{
prFpDrawLine(lower_limit, upper_limit, clr.line, lwd, y.offset)
}
\arguments{
  \item{lower_limit}{The lower limit of the confidence
  line. A native numeric variable that can actually be
  outside the boundaries. If you want to see if it is
  outside then convert it to 'npc' and see if the value
  ends up more than 1 or less than 0. Here's how you do the
  conversion: \code{convertX(unit(upper_limit, "native"),
  "npc", valueOnly = TRUE)} and the
  \code{\link[grid]{convertX}} together with
  \code{\link[grid]{unit}} is needed to get the right
  values while you need to provide the valueOnly as you
  cannot compare a unit object.}

  \item{upper_limit}{The upper limit of the confidence
  line. See lower_limit for details.}

  \item{clr.line}{The color of the line.}

  \item{lwd}{Line width}

  \item{y.offset}{If you have multiple lines they need an
  offset in the y-direction.}
}
\value{
\code{void}
}
\description{
If the line is outside the boundaries the line is clipped
with an arrow at the limit indicating that it continues. If
the lower limit is not below the upper limit the line is
not drawn.
}
\keyword{internal}

