% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pow.R
\name{pow}
\alias{pow}
\title{Raise a numeric vector to a given power}
\usage{
pow(x, y)
}
\arguments{
\item{x}{A numeric vector.}

\item{y}{A numeric value for the power \code{x} should be raised to.}
}
\value{
a numeric vector containing \code{x} to the power of \code{y}.
}
\description{
This function returns a numeric vector raised to a given power.
}
\details{
This function is manly used when fitting statistical models.
If one of the variables in a model is a variable raised to a given power, the \code{lm}
function does not properly compute the variable, if \code{vector^power} is inserted directly
in the model, leading to the need of creating a separate variable. This function allows the user to get the power
of a given numeric vector to \code{y} inside the model, without the need to create a new variable.
}
\examples{
library(forestmangr)
data("exfm15")
head(exfm15)

# Raise a numeric vector to the power of 2:
pow(iris$Petal.Length, 2)

# Fit a model that contains the dbh squared, without the need to create a new variable:
lm(log(TH) ~ DBH + pow(DBH,2), exfm15 )
# or 
lm_table(exfm15, log(TH) ~ DBH + pow(DBH,2) )

}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
